<?php

namespace Merchant\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Employee extends Model 
{

    protected $table = 'employees';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('user_id', 'person_id');
    protected $visible = array('user_id', 'person_id');

    public function user()
    {
        return $this->belongsTo('Merchant\Entities\User', 'user_id', 'id');
    }

    public function person()
    {
        return $this->hasMany('Merchant\Entities\Person', 'person_id', 'id');
    }

    public function contracts()
    {
        return $this->hasMany('Merchant\Entities\EmployeeContract');
    }

}